/* queuep.c  -- Code file for circular buffer */

#include    <stdlib.h>
#include    "qelem.h"

   typedef struct {
     int maxsize, head, tail, count; 
     elemtype q[1000];} queue;
   typedef queue * queuep;

   queuep queueinit(int size){
     queuep fifo = (queuep)malloc(4*sizeof(int)+(size+1)*(sizeof(elemtype)));
     (fifo->maxsize) = size;
     (fifo->head) = 0; (fifo->tail) = 0; (fifo->count) = 0;
     return fifo;
   }

   void put(queuep fifo, elemtype v) {
     if ((fifo->count) <= (fifo->maxsize)) {
       (fifo->count)++;
       fifo->q[(fifo->tail)++] = v;
       if ((fifo->tail) > (fifo->maxsize)) (fifo->tail) = 0;}
   }

   elemtype get(queuep fifo) {
     elemtype t;
     if ((fifo->count) > 0) {
       (fifo->count)--;
       t = (fifo->q)[(fifo->head)++];
       if ((fifo->head) > (fifo->maxsize))(fifo->head)=0;}
     return t;
   }

   int queueempty(queuep fifo) {
     return ((fifo->count) == 0);
   }

   int queuefull(queuep fifo) {
     return ((fifo->count) == (fifo->maxsize));
   }
